-- Messaging for NEW_SESSION_ADDED Event

SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='USER_MGNT');
SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'NEW_SESSION_ADDED');

SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='NEW_SESSION_ADDED');
INSERT INTO `system_msg_event` 
(`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`) 
VALUES (@systemmsgeventId+1, '1', @msgSubCategoryId, 'NEW_SESSION_ADDED', 'New Session Added', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'New Session Added');


SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`) 
VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');


SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);


SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EXTRA_PARAMS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);


-- Template data provider for the NEW_SESSION_ADDED

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'NEW_SESSION_ADDED_DL', 'SQL');

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'NEW_SESSION_ADDED_RECIPIENTS', 'SQL');

-- SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
-- INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'BULK_DOCUMENT_DOWNLOAD_TDP', 'CB');


-- Create Recipient Type 

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='NEW_SESSION_ADDED_RECIPIENTS');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'NEW_SESSION_ADDED_RECIPIENTS');

SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='NEW_SESSION_ADDED_DL');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='NEW_SESSION_ADDED_RECIPIENTS');
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`) 
VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);

-- Setting the query for the Applicant distribution list

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='NEW_SESSION_ADDED_DL');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,"SELECT DISTINCT 
    T7.id AS USER_ID
FROM
    course_coverage_plan T1 
    	LEFT JOIN
    course_variants T2 ON T2.id=T1.courseVariantId
    	LEFT JOIN
    student_course_enrollment T3 on T3.courseVarientId=T2.id
    	LEFT JOIN
    admission T4 on T4.id= T3.admissionId
    	LEFT JOIN
    sections T5 on T5.id = T3.sectionId
    	LEFT JOIN
    students T6 on T6.userId=T4.studentId
    	LEFT JOIN
    users T7 ON T7.id = T6.userId
    	LEFT JOIN
    persons T8 on T8.id = T1.facultyId
WHERE
    T1.id in (namedParams) GROUP BY T7.id ", NULL);

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='NEW_SESSION_ADDED_RECIPIENTS');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`,`sqlQuery`, `jsonString`) 
VALUES (@sqlDtproviderId+1,@dtproviderId,"SELECT DISTINCT
    T6.userId AS ID,
    T7.firstName AS FIRST_NAME,
    T9.printName AS STUDENT_NAME,
	T9.emailId AS EMAIL_ID,
    T9.mobileNumber AS MOBILE_NO,
    T9.mobileCountryCode AS MOBILE_CODE,
	T1.sessionNumber AS SESSION_NUMBER,
    T8.printName AS FACULTY_NAME,
    T10.academyName AS ACADEMY_NAME
FROM
    course_coverage_plan T1 
    	LEFT JOIN
    course_variants T2 ON T2.id=T1.courseVariantId
    	LEFT JOIN
    student_course_enrollment T3 on T3.courseVarientId=T2.id
    	LEFT JOIN
    admission T4 on T4.id= T3.admissionId
    	LEFT JOIN
    sections T5 on T5.id = T3.sectionId
    	LEFT JOIN
    students T6 on T6.userId=T4.studentId
    	LEFT JOIN
    users T7 ON T7.id = T6.userId
    	LEFT JOIN
    persons T8 on T8.id = T1.facultyId
    	LEFT JOIN
    persons T9 on T9.id = T6.personId
		LEFT JOIN
    academy_location T10 ON T10.id = T4.academyLocationId
WHERE
    T7.id IN (namedParams) GROUP BY T7.id ",'{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "printName",
            "resultKey": "STUDENT_NAME",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "emailId",
            "resultKey": "EMAIL_ID",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "mobileNumber",
            "resultKey": "MOBILE_NO",
            "displayCode": "",
            "displayOrder": 2
        },
		{
            "id": 4,
            "value": "mobileCountryCode",
            "resultKey": "MOBILE_CODE",
            "displayCode": "",
            "displayOrder": 3
        },
		{
            "id": 5,
            "value": "sessionNumber",
            "resultKey": "SESSION_NUMBER",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "printName",
            "resultKey": "FACULTY_NAME",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 6
        }
    ]
}');

SET @dtprvdrinputparamId=(SELECT MAX(id) FROM dtprvdr_input_param);
SET @dtproviderId=(SELECT id FROM `dtprovider` where `dataProviderName`='NEW_SESSION_ADDED_DL');
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `dtprvdr_input_param` (`id`, `dataProviderId`, `paramName`, `paramDataType`, `paramType`, `msgScopeParamId`, `operatorCode`, `additionalInputParamId`) VALUES(@dtprvdrinputparamId+1,@dtproviderId,'T1.id','NUMBER_EQUAL','SCOPEPARAM',@msgScopeParamId,'NUMBER_EQUAL',NULL);

SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='NEW_SESSION_ADDED');

SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='NEW_SESSION_ADDED');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='NEW_SESSION_ADDED_RECIPIENTS');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='GeneralMessage');


INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`) 
VALUES(@msgtemplateconfigId+1,'New Session Added',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,4,NULL,NULL,'New Session Added',NULL,'',NULL,'','APPROVED','','1','System Admin System Admin','1');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','New Session Added','<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			 <p align="left">Hi $recipientData[&quot;STUDENT_NAME&quot;],</p>
			 <p align="left">A new session $recipientData[&quot;SESSION_NUMBER&quot;], has been added to your timetable. </p>
			</td>
		</tr>
		<tr>
			<td style="padding:20px 20px 20px 20px;"><p align="left">$recipientData[&quot;ACADEMY_NAME&quot;]</p></td>
		</tr>
	</tbody>
</table>
</body>
</html>');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+2,@msgtemplateconfigId+1,'4','New Session Added','<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			 <p align="left">Hi $recipientData[&quot;STUDENT_NAME&quot;],</p>
			 <p align="left">A new session $recipientData[&quot;SESSION_NUMBER&quot;], has been added to your timetable. </p>
			</td>
		</tr>
		<tr>
			<td style="padding:20px 20px 20px 20px;"><p align="left">$recipientData[&quot;ACADEMY_NAME&quot;]</p></td>
		</tr>
	</tbody>
</table>
</body>
</html>');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateId+3,@msgtemplateconfigId+1,'6',NULL,'Hi $recipientData[&quot;STUDENT_NAME&quot;], A new session $recipientData[&quot;SESSION_NUMBER&quot;], has been added to your timetable.');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateId+4,@msgtemplateconfigId+1,'2',NULL,'Hi $recipientData[&quot;STUDENT_NAME&quot;], A new session $recipientData[&quot;SESSION_NUMBER&quot;], has been added to your timetable.');

SET sql_safe_updates=0;
update msg_template_config set whetherEnabled=1 where whetherEnabled is null;
update msg_template_config set templateLanguageValue ='English' where templateLanguageValue is null;   
SET sql_safe_updates=1;
-- End Messaging for NEW_SESSION_ADDED Event